/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsExt;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsTasklet;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsUtils;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.websm.etc.EWorkingListener;
import java.util.ArrayList;
import java.util.Iterator;

public class IOSurveyRunSurveyTask {
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    private static final short ERRID_0020 = 32;
    private static final short ERRID_0021 = 33;
    private static final short ERRID_0022 = 34;
    private static final int REMOVABLE_MEDIA = 0;
    private static final int LOCAL_MEDIA = 1;
    private Object threadLock = new Object();
    private Object dataLock = new Object();
    private int threadCount;
    private int threadTotal;
    public int surveyIndex;
    private SurveyFileResult[] surveyFileArray;
    private ArrayList resourceExceptions;
    private EWorkingListener listener;
    public IOSurveyResultsExt ioResultsExt;
    private boolean surveyedFrames = false;
    LocalizableText userResponse;
    IOSurveyResultsData resultsData;
    IOSurveyResultsTasklet ioTasklet;
    IOSurveyResultsUtils ioUtils;
    private final String DEFAULT_TARGET_DIRECTORY = "/var/adm/invscout/";
    private final String MICROCODE_TARGET_DIRECTORY = "/var/adm/invscout/microcode/";
    private final String catalogFile = "catalog.mic";

    public IOSurveyRunSurveyTask(IOSurveyResultsData iOSurveyResultsData) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyRunSurveyTask()");
        }
        this.resultsData = iOSurveyResultsData;
        this.ioTasklet = iOSurveyResultsData.getIOSurveyTasklet();
        this.ioUtils = iOSurveyResultsData.getIOUtils();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyRunSurveyTask()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurveyFileResult[] runSurvey() throws UcodeSurveyException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyRunSurveyTask.runSurvey()");
        }
        String string = "";
        RepositoryItem repositoryItem = this.resultsData.getReposLevel();
        string = repositoryItem.getReposType() == 1 ? "/microcode/catalog.mic" : "catalog.mic";
        try {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Downloading Catalog file /var/adm/invscout/microcode/catalog.mic");
            }
            this.resultsData.getIODownload().RPMPackageDownload(string, repositoryItem, "/var/adm/invscout/microcode/");
        }
        catch (Exception exception) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "<- IOSurveyRunSurveyTask().runSurvey() ERROR downloading survey catalog file: " + exception);
            }
            throw new UcodeSurveyException(exception.toString());
        }
        ArrayList arrayList = this.resultsData.getTargets();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "Starting surveys from selected resources...");
        }
        this.surveyFileArray = new SurveyFileResult[arrayList.size()];
        this.threadTotal = 0;
        this.threadCount = 0;
        this.surveyIndex = 0;
        this.resourceExceptions = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ResourceItem resourceItem = (ResourceItem)iterator.next();
            if (!this.surveyedFrames || resourceItem.getResourceType() != 6) {
                this.updateResourcesThread(resourceItem);
                ++this.threadTotal;
            }
            if (resourceItem.getResourceType() != 6) continue;
            this.surveyedFrames = true;
        }
        while (this.threadCount < this.threadTotal) {
            try {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "Thread wait: current complete count is " + this.threadCount + " of " + this.threadTotal);
                }
                Object object = this.threadLock;
                synchronized (object) {
                    if (this.threadCount < this.threadTotal) {
                        this.threadLock.wait();
                    }
                }
                if (1 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKD, "Thread notify complete for thread " + this.threadCount);
            }
            catch (Exception exception) {
                if (1 > Trace.LEVEL) continue;
                Trace.trace(TRACE_MASKD, "Exception " + exception + " waiting on thread " + this.threadCount);
            }
        }
        if (this.resourceExceptions.size() > 0) {
            this.resultsData.setResourceExceptions(this.resourceExceptions);
            if (this.surveyIndex == 0) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "runSurvey() processing contained errors");
                    Trace.trace(TRACE_MASKT, "<- IOSurveyRunSurveyTask.runSurvey()");
                }
                throw new UcodeSurveyException("Error(s) processing all surveys");
            }
        }
        if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKD, "runSurvey() processing was successful!\n");
            Trace.trace(TRACE_MASKT, "<- IOSurveyRunSurveyTask.runSurvey()");
        }
        return this.surveyFileArray;
    }

    private void updateResourcesThread(final ResourceItem resourceItem) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(IOSurveyRunSurveyTask.TRACE_MASKT, "-> IOSurveyRunSurveyTask.updateResources.run()");
                }
                IOSurveyRunSurveyTask.this.updateResources(resourceItem);
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateResources(ResourceItem resourceItem) {
        Object object;
        boolean bl = false;
        String string = " ";
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyRunSurveyTask.updateResources()");
        }
        try {
            object = " ";
            ArrayList arrayList = new ArrayList();
            string = resourceItem.getMTMS();
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Resource MTMS: " + string);
            }
            try {
                Object[] objectArray = new Object[]{string};
                object = resourceItem.getResourceType() == 6 ? "0000-000_0000000" : string;
                SurveyFileResult surveyFileResult = this.resultsData.getIOResultsExt().doEfixSurvey((String)object, "/var/adm/invscout/");
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "doEfixSurvey request was successful for " + string);
                }
                Object[] objectArray2 = this.dataLock;
                synchronized (this.dataLock) {
                    this.surveyFileArray[this.surveyIndex] = surveyFileResult;
                    ++this.surveyIndex;
                    // ** MonitorExit[var8_12] (shouldn't be in output)
                    objectArray2 = new Object[]{string};
                }
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                Object[] objectArray = ucodeSurveyException.getArgs();
                Object[] objectArray3 = new Object[]{string};
                if (objectArray == null) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, " IOSurveyRunSurveyTask args = null");
                    }
                    if (this.resultsData.getTaskletInterface()) {
                        this.ioTasklet.showErrorMessageBox(ucodeSurveyException.getKey());
                    }
                } else {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, " IOSurveyRunSurveyTask args = " + objectArray[0]);
                    }
                    if (this.resultsData.getTaskletInterface()) {
                        this.ioTasklet.showErrorMessageBox(ucodeSurveyException.getKey(), objectArray);
                    }
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Exception being saved in resourceExcpetions");
                }
                ArrayList arrayList2 = this.resourceExceptions;
                synchronized (arrayList2) {
                    this.resourceExceptions.add(ucodeSurveyException);
                }
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Exception processing survey: " + throwable);
            }
            if (this.resultsData.getTaskletInterface()) {
                objectArray = new Object[2];
                objectArray[1] = throwable.toString();
                objectArray[0] = string;
                this.ioTasklet.showErrorMessageBox("0004", objectArray);
            }
            objectArray = this.resourceExceptions;
            synchronized (objectArray) {
                this.resourceExceptions.add(new UcodeSurveyException(throwable.toString()));
            }
        }
        {
            object = this.threadLock;
            synchronized (object) {
                ++this.threadCount;
                this.threadLock.notify();
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<- IOSurveyRunSurveyTask.updateResources()");
            }
            return;
        }
    }
}

